package com.bxm.adscounter.service;

import com.bxm.openlog.sdk.listener.EnableLogSubscriberFactory;
import com.bxm.openlog.sdk.listener.eventbus.EnableOpenLogEventBusFactory;
import com.bxm.warcar.integration.autoconfigure.distributed.EnableDistributedScheduling;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;

/**
 * @author yirenjie
 * createDate:  2019/3/29
 */
@SpringBootApplication
@ComponentScan(basePackages = {"com.bxm.adscounter", "com.bxm.adsprod.counter"})
@EnableFeignClients(basePackages = {"com.bxm.adsprod.facade"})
@EnableConfigurationProperties
@EnableLogSubscriberFactory
@EnableOpenLogEventBusFactory
@EnableDistributedScheduling
public class AdscounterServiceApplication {

    public static void main(String[] args) {
        SpringApplication.run(AdscounterServiceApplication.class, args);
    }
}
