package com.bxm.adscounter.service;

import java.util.List;

import com.bxm.adscounter.facade.model.SspUserData;

/**
 * ssp用户信息<br/>
 *
 * @author kerry.jiang
 * @date 2021/9/9 18:31
 */
public interface SspUserService {

    /**
     * 记录参与活动次数
     */
    void plusActivityJoin(String appId, String positionId, String uid);

    /**
     * 批量查询指定应用 自定义用户ID 的用户统计数据
     * @param appId 应用ID
     * @param cuids 自定义用户ID
     * @param date 日期
     * @return 用户统计数据
     */
    List<SspUserData> getActivityJoinByAppId(String appId, String[] cuids, String date);

    /**
     * 批量查询指定应用 自定义用户ID 的用户统计数据
     * @param appId 应用ID
     * @param positionId 广告位ID
     * @param cuids 自定义用户ID
     * @param date 日期
     * @return 用户统计数据
     */
    List<SspUserData> getActivityJoinByAppId(String appId, String positionId, String[] cuids, String date);

}
