package com.bxm.adscounter.service.autoconfigure;

import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

/**
 * <p></p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/7/26
 */
@Configuration
@EnableConfigurationProperties(OldRedisConfiguration.class)
public class OldRedisAutoConfiguration {
    private final OldRedisConfiguration oldConfiguration;

    public OldRedisAutoConfiguration(OldRedisConfiguration oldConfiguration) {
        this.oldConfiguration = oldConfiguration;
    }

    @Bean
    public JedisPool jedisPoolOld() {
        return new JedisPool(oldConfiguration, oldConfiguration.getHost(), oldConfiguration.getPort(), oldConfiguration.getTimeout(),
                oldConfiguration.getPassword(), oldConfiguration.getDatabase());
    }

    @Bean
    public JedisFetcher jedisFetcherForOld1() {
        return new JedisFetcher(jedisPoolOld1());
    }

    @Bean
    public JedisPool jedisPoolOld1() {
        return new JedisPool(oldConfiguration, oldConfiguration.getHost(), oldConfiguration.getPort(), oldConfiguration.getTimeout(),
                oldConfiguration.getPassword());
    }

}
