package com.bxm.adscounter.service.autoconfigure;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

/**
 * @author allen
 * @date 2022-04-20
 * @since 1.0
 */
@Configuration
@EnableConfigurationProperties(JedisVisionConfiguration.class)
public class VisionAutoConfiguration {

    private final JedisVisionConfiguration visionConfiguration;

    public VisionAutoConfiguration(JedisVisionConfiguration visionConfiguration) {
        this.visionConfiguration = visionConfiguration;
    }

    @Bean
    public JedisPool visionJedisPool() {
        return new JedisPool(visionConfiguration, visionConfiguration.getHost(), visionConfiguration.getPort(),
                visionConfiguration.getTimeout(), visionConfiguration.getPassword(), visionConfiguration.getDatabase());
    }
}
