package com.bxm.adscounter.service.autoconfigure.tfbredis;

import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;


/**
 * @author daill
 * @since 1.0.0
 */
@Configuration
@EnableConfigurationProperties(TfbRedisProperties.class)
public class TfbRedisConfiguration {

    private final TfbRedisProperties tfbRedisProperties;

    public TfbRedisConfiguration(TfbRedisProperties tfbRedisProperties) {
        this.tfbRedisProperties = tfbRedisProperties;
    }

    @Bean
    public JedisPool jedisPoolForTFB() {
        return new JedisPool(tfbRedisProperties, tfbRedisProperties.getHost(), tfbRedisProperties.getPort(), tfbRedisProperties.getTimeout(),
                tfbRedisProperties.getPassword(), tfbRedisProperties.getDatabase());
    }


    @Bean
    public JedisUpdater jedisUpdaterForTFB() {
        return new JedisUpdater(jedisPoolForTFB());
    }


}

