package com.bxm.adscounter.service.listeners.effect;


import com.bxm.adscounter.model.EffectEndpoint;
import com.bxm.adscounter.model.constant.AdGroupCounterConstant;
import com.bxm.adscounter.model.constant.TicketRedisKeyConstant;
import com.bxm.adscounter.service.autoconfigure.RedisClient;
import com.bxm.adscounter.service.events.EffectEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author yirenjie
 * createDate:  2019/3/28
 */
@Slf4j
@Service
public class Push2RedisEffectEventListener implements EventListener<EffectEvent> {

    @Resource
    private RedisClient redisClient;

    /**
     * 消费消息事件
     *
     */
    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(EffectEvent event) {
        EffectEndpoint endpoint = event.getEndpoint();

        //保存广告组数据到 old_redis
        if (1 == Integer.valueOf(endpoint.getStatus())) {
            String dateTime = DateHelper.format(DateHelper.PATTERN_STR10);
            String redisMsg = KeyBuilder.build(dateTime, endpoint.getAppKey(), endpoint.getBusiness(), endpoint.getActivityId(),
                    endpoint.getTicketId(), endpoint.getMt());
            redisClient.sAddToOldRedis(KeyBuilder.build(AdGroupCounterConstant.AD_SHOP_TOTAL_KEY, dateTime, endpoint.getMt()), redisMsg, TicketRedisKeyConstant.CLICK_DB_INDEX, AdGroupCounterConstant.AD_SHOP_OUT_SECONDS);
            redisClient.pfaddToOldRedis(redisMsg, endpoint.getOrderId(), TicketRedisKeyConstant.CLICK_DB_INDEX, AdGroupCounterConstant.AD_SHOP_OUT_SECONDS);
        }
    }
}
