package com.bxm.adscounter.service.listeners.general.activity.join;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.model.constant.TicketCounterConstant;
import com.bxm.adscounter.model.constant.TicketRedisKeyConstant;
import com.bxm.adscounter.service.SspUserService;
import com.bxm.adscounter.service.autoconfigure.RedisClient;
import com.bxm.adscounter.service.events.ActivityJoinEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 挽留弹窗点击统计
 *
 * @author yirenjie
 * createDate:  2019/3/27
 */
@Service
@Slf4j
public class PopupClickJoinEventListener implements EventListener<ActivityJoinEvent> {

    @Resource
    private RedisClient redisClient;
    @Resource
    private SspUserService sspUserService;

    /**
     * 挽留弹窗点击统计
     *
     * @param event 事件对象
     */
    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityJoinEvent event) {
        GeneralEndpoint endpoint = event.getEndpoint();
        if(null != endpoint.getSspAppId()){
            sspUserService.plusActivityJoin(endpoint.getSspAppId(), endpoint.getSspPositionId(),
                    endpoint.getUid());
        }
        if (TicketCounterConstant.SCENE_TYPE_STAY == endpoint.getScene() && StringUtils.isNotBlank(endpoint.getPopupId())) {

            String business = endpoint.getBusiness();

            if (StringUtils.isBlank(business)) {
                return;
            }
            String positionId = endpoint.getAppKey() + business.replace("ad", "");
            redisClient.hincrBy(() -> KeyBuilder.build("AD", "ACTIVITY", "POPUP", "CLICK",
                    TicketCounterConstant.SceneType.getValue(endpoint.getScene()), positionId),
                    endpoint.getPopupId(), 1, TicketRedisKeyConstant.COUNTER_DB_INDEX);
        }
    }
}
// AD:ACTIVITY:POPUP:CLICK:${SceneType}:${positionId}