package com.bxm.adscounter.service.listeners.general.activity.show;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.model.constant.TicketCounterConstant;
import com.bxm.adscounter.model.constant.TicketRedisKeyConstant;
import com.bxm.adscounter.service.autoconfigure.RedisClient;
import com.bxm.adscounter.service.events.ActivityShowEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author yirenjie
 * createDate:  2019/3/28
 */
@Service
@Slf4j
public class StayPopupUVShowEventListener implements EventListener<ActivityShowEvent> {

    @Resource
    private RedisClient redisClient;

    /**
     * 挽留弹窗曝光uv统计
     *
     * @param event 事件对象
     */
    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityShowEvent event) {
        GeneralEndpoint endpoint = event.getEndpoint();


        if (TicketCounterConstant.SCENE_TYPE_STAY == endpoint.getScene() && StringUtils.isNotBlank(endpoint.getPopupId())) {

            //首页UV 用于计算参与率
            String business = endpoint.getBusiness();
            if (StringUtils.isBlank(business)) {
                return;
            }
            String positionId = endpoint.getAppKey() + business.replace("ad", "");
            redisClient.pfadd(() -> KeyBuilder.build("AD", "ACTIVITY", "POPUP", "INDEXUV",
                    TicketCounterConstant.SceneType.getValue(endpoint.getScene()), endpoint.getPopupId(), positionId),
                    endpoint.getUid(), TicketRedisKeyConstant.COUNTER_DB_INDEX);

        }
    }
}
