package com.bxm.adscounter.service.listeners.general.ticket.click;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.model.constant.TicketCounterConstant;
import com.bxm.adscounter.model.constant.TicketRedisKeyConstant;
import com.bxm.adscounter.service.autoconfigure.RedisClient;
import com.bxm.adscounter.service.events.TicketClickAsyncEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 广告弹窗点击事件
 *
 * @author yirenjie
 * createDate:  2019/3/26
 */
@Service
@Slf4j
public class AdPopupClickEventListener implements EventListener<TicketClickAsyncEvent> {

    @Resource
    private RedisClient redisClient;

    /**
     * 广告弹窗点击统计
     *
     * @param event 事件对象
     */
    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickAsyncEvent event) {
        GeneralEndpoint endpoint = event.getEndpoint();

        if (StringUtils.isNotBlank(endpoint.getPopupId()) && TicketCounterConstant.SCENE_TYPE_STAY != endpoint.getScene()) {
            String business = endpoint.getBusiness();
            if (StringUtils.isNotBlank(business)) {
                String positionId = endpoint.getAppKey() + business.replace("ad", "");
                //弹窗统计
                redisClient.hincrBy(() -> KeyBuilder.build("AD", "ACTIVITY", "POPUP", "CLICK",
                        TicketCounterConstant.SceneType.getValue(endpoint.getScene()), positionId),
                        endpoint.getPopupId(), 1, TicketRedisKeyConstant.COUNTER_DB_INDEX);
            }
        }
    }
}
