package com.bxm.adscounter.service.listeners.general.ticket.click;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.model.constant.TicketRedisKeyConstant;
import com.bxm.adscounter.service.autoconfigure.RedisClient;
import com.bxm.adscounter.service.events.TicketClickAsyncEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 广告位活动点击数据
 *
 * @author yirenjie
 * createDate:  2019/3/26
 */
@Service
@Slf4j
public class AdPositionActivityClickEventListener implements EventListener<TicketClickAsyncEvent> {

    @Resource
    private RedisClient redisClient;

    /**
     * 保存广告位活动点击数据
     *
     * @param event 事件对象
     */
    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickAsyncEvent event) {
        GeneralEndpoint endpoint = event.getEndpoint();
        String business = endpoint.getBusiness();
        if (StringUtils.isBlank(business)) {
            return;
        }
        String positionId = endpoint.getAppKey() + business.replace("ad", "");
        redisClient.incr(() -> KeyBuilder.build("AD", "COUNTER", "ACTIVITY", "ALL", "CLICK",
                endpoint.getActivityId(), positionId), TicketRedisKeyConstant.COUNTER_DB_INDEX);
    }
}
