package com.bxm.adscounter.service.listeners.general.ticket.click;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.service.events.TicketClickAsyncEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;


/**
 * @author: zm
 * @date: 2019-09-02 11:02
 * @Description: fm出券算法广告券出价统计相关
 */
@Service
public class FmTicketClickOfferEventListener implements EventListener<TicketClickAsyncEvent> {

    @Autowired
    @Qualifier("jedisUpdaterForFM")
    private JedisUpdater jedisUpdaterForFM;


    /**
     * 点击出价
     *
     * @param event 事件对象
     */
    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickAsyncEvent event) {
        if (event == null) {
            return;
        }
        Ticket ticket = event.getTicket();
        if (ticket != null && ticket.getOfferPrice() != null && event.getEndpoint() != null) {
            GeneralEndpoint endpoint = event.getEndpoint();
            Integer offerPrice = ticket.getOfferPrice();
            if (StringUtils.isBlank(endpoint.getUid())) {
                return;
            }
            // 保存全局前一单计费金额 3d
            jedisUpdaterForFM.hupdate(TicketKeyGenerator.TicketFm.getLaterUser(endpoint.getUid()),
                    TicketKeyGenerator.TicketFm.getPrevCost().generateKey(), offerPrice, (int) TimeUnit.DAYS.toSeconds(3));
            //保存全局活动前一单计费金额 3d
            if (endpoint.getActivityId() != null) {
                jedisUpdaterForFM.hupdate(TicketKeyGenerator.TicketFm.getLaterUser(endpoint.getUid()),
                        TicketKeyGenerator.TicketFm.getPrevCost(endpoint.getActivityId()).generateKey(), offerPrice, (int) TimeUnit.DAYS.toSeconds(3));
            }
            //保存素材上一次是否计费
            if (StringUtils.isNotBlank(endpoint.getAssetsId())) {
                jedisUpdaterForFM.hupdate(TicketKeyGenerator.TicketFm.getLaterUser(endpoint.getUid()),
                        TicketKeyGenerator.TicketFm.getPrevAssetIdCost(Long.valueOf(endpoint.getAssetsId())).generateKey(), offerPrice, (int) TimeUnit.DAYS.toSeconds(3));
            }
        }
    }
}
