package com.bxm.adscounter.service.listeners.general.ticket.click;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.model.TicketClickMsg;
import com.bxm.adscounter.model.constant.AdGroupCounterConstant;
import com.bxm.adscounter.model.constant.TicketRedisKeyConstant;
import com.bxm.adscounter.service.events.TicketClickAsyncEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * new信息存档
 * @author yirenjie
 * createDate:  2019/3/26
 */
@Service
@Slf4j
public class NewInfoKeeperClickEventListener implements EventListener<TicketClickAsyncEvent> {

    @Resource
    @Qualifier("jedisUpdater")
    private Updater jedisUpdater;

    /**
     * new信息存档
     *
     * @param event 事件对象
     */
    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickAsyncEvent event) {
        GeneralEndpoint endpoint = event.getEndpoint();

        TicketClickMsg ticketClickMsg = new TicketClickMsg(endpoint.getIp(),
                endpoint.getAppKey(),endpoint.getBusiness(),endpoint.getActivityId(),endpoint.getTicketId(),
                endpoint.getUid(),endpoint.getAssetsId(),endpoint.getAppos(),endpoint.getApp(),
                endpoint.getUseType(), endpoint.getCouponsCode(), endpoint.getExtJson());
        ticketClickMsg.setLandId(endpoint.getLandId());
        ticketClickMsg.setEntrTicketId(endpoint.getEntranceTicketId());
        ticketClickMsg.setEntrAssetsId(endpoint.getEntranceAssetsId());
        ticketClickMsg.setBidid(endpoint.getBidid());
        ticketClickMsg.setObidid(endpoint.getObidid());
        ticketClickMsg.setAdxAppId(endpoint.getAdxAppId());
        ticketClickMsg.setReferrer(endpoint.getReferrer());
        ticketClickMsg.setUserAgent(endpoint.getUserAgent());
        ticketClickMsg.setOcpaOfferPrice(endpoint.getOcpaOfferPrice());
        ticketClickMsg.setTargetConvType(endpoint.getTargetConvType());
        ticketClickMsg.setSettleType(endpoint.getSettleType());
        //默认过期时间 3天
        int expire = TicketRedisKeyConstant.CLICK_EXPIRE;
        //ocpa的券改为过期时间为7天
        if (endpoint.getSettleType() == Ticket.SETTLE_TYPE_OCPA) {
            expire = TicketRedisKeyConstant.OCPA_CLICK_EXPIRE;
        }
        jedisUpdater.updateWithSelector(() -> KeyBuilder.build(TicketRedisKeyConstant.CLICK_HEAD_NEW,
                endpoint.getOrderId()), JSONObject.toJSONString(ticketClickMsg), expire,
                AdGroupCounterConstant.CLICK_DB_INDEX);



    }
}
