package com.bxm.adscounter.service.listeners.general.ticket.click;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.model.constant.TicketRedisKeyConstant;
import com.bxm.adscounter.service.autoconfigure.RedisClient;
import com.bxm.adscounter.service.events.TicketClickAsyncEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * old redis信息存档
 *
 * @author yirenjie
 * createDate:  2019/3/26
 */
@Service
@Slf4j
public class OldInfoKeeperClickEventListener implements EventListener<TicketClickAsyncEvent> {

    @Resource
    private RedisClient redisClient;

    /**
     * 消费消息事件
     *
     * @param event 事件对象
     */
    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickAsyncEvent event) {
        GeneralEndpoint endpoint = event.getEndpoint();

        String value = KeyBuilder.build(endpoint.getIp(), endpoint.getAppKey(),
                endpoint.getBusiness(), endpoint.getActivityId(), endpoint.getTicketId(),
                endpoint.getUid(), endpoint.getAssetsId(),
                endpoint.getAppos(), endpoint.getApp());

        redisClient.setToOldRedis(() -> KeyBuilder.build(TicketRedisKeyConstant.CLICK_HEAD,
                endpoint.getOrderId()), value,
                TicketRedisKeyConstant.CLICK_DB_INDEX, TicketRedisKeyConstant.CLICK_EXPIRE);
    }
}
