package com.bxm.adscounter.service.listeners.general.ticket.click;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.model.constant.TicketRedisKeyConstant;
import com.bxm.adscounter.service.events.TicketClickAsyncEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 点击出价
 * @author yirenjie
 * createDate:  2019/3/26
 */
@Service
@Slf4j
public class TicketClickOfferEventListener implements EventListener<TicketClickAsyncEvent> {

    @Resource
    @Qualifier("jedisUpdater")
    private Updater jedisUpdater;

    /**
     * 点击出价
     *
     * @param event 事件对象
     */
    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickAsyncEvent event) {
        Ticket ticket = event.getTicket();
        GeneralEndpoint endpoint = event.getEndpoint();
        Integer offerPrice = ticket.getOfferPrice();
        jedisUpdater.updateWithSelector(() -> KeyBuilder.build("AD","OCPC","OFFER_PRICE",endpoint.getOrderId()),
                null == offerPrice ? 0 : offerPrice,
                TicketRedisKeyConstant.CLICN_PRICE_OUT_TIME, TicketRedisKeyConstant.CLICN_PRICE_DB_INDEX);
    }
}
