package com.bxm.adscounter.service.listeners.general.ticket.show;

import com.bxm.adscounter.facade.model.fm.FmPrevTicketCountDto;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.service.events.TicketShowEvent;
import com.bxm.adsprod.facade.tag.Tag;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketAssets;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.xcache.TargetFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * @author: zm
 * @date: 2019-09-02 11:02
 * @Description: fm出券算法广告券统计相关 (实时数据存储)
 */
@Service
public class FmTicketShowCountEventListener implements EventListener<TicketShowEvent> {


    private static final Logger logger = LoggerFactory.getLogger(FmTicketShowCountEventListener.class);

    public static final String CACHE_DEFAULT_VALUE = "1";

    @Autowired
    @Qualifier("jedisFetcher")
    private com.bxm.warcar.cache.Fetcher fetcher;

    @Autowired
    @Qualifier("jedisFetcherForFM")
    private JedisFetcher jedisFetcherForFM;

    @Autowired
    @Qualifier("jedisUpdaterForFM")
    private JedisUpdater jedisUpdaterForFM;


    @Autowired
    @Qualifier("jedisCounterForFM")
    private JedisCounter jedisCounterForFM;


    @Autowired
    @Qualifier("fmCacheFetcher")
    private com.bxm.warcar.xcache.Fetcher xfetcher;

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketShowEvent event) {
        GeneralEndpoint endpoint = event.getEndpoint();
        if (endpoint == null || StringUtils.isBlank(endpoint.getUid())) {
            return;
        }
        //存储广告券标签相关数据
        saveTicketCountFromFm(endpoint, event.getTicket());
        //设置实时数据
        saveUserActualDataFromFm(endpoint);
    }


    /**
     * 存储用户实时数据
     *
     * @param endpoint
     */
    private void saveUserActualDataFromFm(GeneralEndpoint endpoint) {
        String spm = endpoint.getSpm();
        //判断该活动是否在进行中
        if (StringUtils.isNotBlank(spm) && endpoint.getActivityId() != null) {
            /*String spmCount = jedisFetcherForFM.hfetch(TicketKeyGenerator.TicketFm.getSpm(), spm, String.class);
            if (StringUtils.isNotBlank(spmCount)) {
                if (endpoint.getActivityId() != null) {
                    jedisCounterForFM.hincrementAndGet(TicketKeyGenerator.TicketFm.getCurrentUser(endpoint.getUid()),
                            TicketKeyGenerator.TicketFm.getCurrentActivity(endpoint.getActivityId()).generateKey());
                }
            } else {
                //存储spm (首次参加活动)
                jedisUpdaterForFM.hupdate(TicketKeyGenerator.TicketFm.getSpm(), spm, CACHE_DEFAULT_VALUE,
                        (int) DateHelper.getRemainSecondsOfToday());

                if (endpoint.getActivityId() != null) {
                    // 用户当前活动发券次序（当前这个活动第几次发券）
                    jedisUpdaterForFM.hupdate(TicketKeyGenerator.TicketFm.getCurrentUser(endpoint.getUid()),
                            TicketKeyGenerator.TicketFm.getCurrentActivity(endpoint.getActivityId()).generateKey(),
                            1, (int) DateHelper.getRemainSecondsOfToday());
                }
            }*/
            jedisCounterForFM.hincrementAndGet(TicketKeyGenerator.TicketFm.getCurrentUser(endpoint.getUid()),
                    TicketKeyGenerator.TicketFm.getCurrentActivity(endpoint.getActivityId()).generateKey());

        }

        //存储用户当日发券订单排序
        jedisCounterForFM.hincrementByAndGet(TicketKeyGenerator.TicketFm.getCurrentUser(endpoint.getUid()),
                TicketKeyGenerator.TicketFm.getTicketCountCurrentDay().generateKey(), 1, (int) DateHelper.getRemainSecondsOfToday());

        if (endpoint.getTicketId() != null) {
            //存储用户当日第几次重复发该券
            jedisCounterForFM.hincrementByAndGet(TicketKeyGenerator.TicketFm.getCurrentUser(endpoint.getUid()),
                    TicketKeyGenerator.TicketFm.getTicketCountRepeat(endpoint.getTicketId()).generateKey(), 1, (int) DateHelper.getRemainSecondsOfToday());
        }

        if (endpoint.getActivityId() != null) {
            //存储用户当日该活动订单次数
            jedisCounterForFM.hincrementByAndGet(TicketKeyGenerator.TicketFm.getCurrentUser(endpoint.getUid()),
                    TicketKeyGenerator.TicketFm.getActivityCount(endpoint.getActivityId()).generateKey(), 1, (int) DateHelper.getRemainSecondsOfToday());
        }


        if (StringUtils.isNotBlank(endpoint.getAssetsId())) {
            //存储用户当日发素材次数
            jedisCounterForFM.hincrementByAndGet(TicketKeyGenerator.TicketFm.getCurrentUser(endpoint.getUid()),
                    TicketKeyGenerator.TicketFm.getSeqAssetIdViewCount(Long.valueOf(endpoint.getAssetsId())).generateKey(), 1, (int) DateHelper.getRemainSecondsOfToday());

        }

    }

    /**
     * 存储广告券相关数据
     *
     * @param endpoint
     * @param ticket
     */
    private void saveTicketCountFromFm(GeneralEndpoint endpoint, Ticket ticket) {
        //获取 广告券id
        Long ticketId = endpoint.getTicketId();
        //获取活动id
        Long activityId = endpoint.getActivityId();
        if (ticketId == null && activityId == null) {
            return;
        }

        //获取广告券对应的分类标签
        String tags = null;
        if (ticket == null) {
            if (ticketId != null) {
                ticket = fetcher.hfetch(TicketKeyGenerator.getAllTickets(), String.valueOf(ticketId), null, Ticket.class);
            }
        }
        List<String> tagCodes = null;
        if (ticket != null && !CollectionUtils.isEmpty(ticket.getTags())) {
            Set<String> tagsSet = xfetcher.fetch(new TargetFactory<Set>()
                    .keyGenerator(TicketKeyGenerator.getAttributeTag())
                    .cls(Set.class)
                    .build());
            tagCodes = ticket.getTags().stream().map(Tag::getCode).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(tagsSet)) {
                //去除属性标签
                tagCodes.removeAll(tagsSet);
            }
        }
        //获取分类标签的一二三级信息
        if (!CollectionUtils.isEmpty(tagCodes)) {
            for (String tagCode : tagCodes) {
                //获取标签对应的一二三级标签信息
                tags = jedisFetcherForFM.hfetch(TicketKeyGenerator.Tags.getTags(), tagCode, String.class);
                if (StringUtils.isNotBlank(tags)) {
                    break;
                }
            }
        }
        FmPrevTicketCountDto ticketCountDto = new FmPrevTicketCountDto();
        ticketCountDto.setActivityId(activityId == null ? -1 : activityId);
        ticketCountDto.setTicketId(ticketId == null ? -1 : ticketId);
        ticketCountDto.setTags(tags == null ? StringUtils.EMPTY : tags);
        //存储数据
       // jedisUpdaterForFM.hupdate(TicketKeyGenerator.TicketFm.getPrevTicketInfo(), endpoint.getUid(), ticketCountDto, (int) DateHelper.getRemainSecondsOfToday());

        jedisUpdaterForFM.update(getPrevTicketInfoByUid(endpoint.getUid()), ticketCountDto, (int) DateHelper.getRemainSecondsOfToday());
    }

    public static KeyGenerator getPrevTicketInfoByUid(String uid) {
        return () -> KeyBuilder.build("ADA", "RECORD", "USERS", "DATE", DateHelper.getDate(),uid);
    }
}
