package com.bxm.adscounter.service.listeners.general.ticket.show;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.model.constant.TicketCounterConstant;
import com.bxm.adscounter.model.constant.TicketRedisKeyConstant;
import com.bxm.adscounter.service.autoconfigure.RedisClient;
import com.bxm.adscounter.service.events.TicketShowEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 非挽留弹窗统计
 *
 * @author yirenjie
 * createDate:  2019/3/27
 */
@Service
@Slf4j
public class NonStayPopupShowEventListener implements EventListener<TicketShowEvent> {

    @Resource
    private RedisClient redisClient;

    /**
     * 非挽留弹窗统计
     *
     * @param event 事件对象
     */
    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketShowEvent event) {
        GeneralEndpoint endpoint = event.getEndpoint();
        if (TicketCounterConstant.SCENE_TYPE_STAY != endpoint.getScene() && StringUtils.isNotBlank(endpoint.getPopupId())) {
            String business = endpoint.getBusiness();
            if (StringUtils.isBlank(business)) {
                return;
            }
            String positionId = endpoint.getAppKey() + business.replace("ad", "");
            redisClient.hincrBy(() -> KeyBuilder.build("AD", "ACTIVITY", "POPUP", "VIEW",
                    TicketCounterConstant.SceneType.getValue(endpoint.getScene()), positionId),
                    endpoint.getPopupId(), 1, TicketRedisKeyConstant.COUNTER_DB_INDEX);
        }
    }
}
