package com.bxm.adscounter.service.openlog.common;

import com.bxm.adscounter.service.openlog.common.event.*;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEventBusBean;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEventConfig;
import com.bxm.warcar.integration.eventbus.EventPark;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;

/**
 * @author allen
 * @date 2022-02-16
 * @since 1.0
 */
@Configuration
public class DefaultOpenLogEventBusBean implements OpenLogEventBusBean {

    private final EventPark eventPark;

    public DefaultOpenLogEventBusBean(EventPark eventPark) {
        this.eventPark = eventPark;
    }

    @Override
    public String getId() {
        return "ADSCOUNTER";
    }

    @Override
    public Production getProduction() {
        return Production.COMMON;
    }

    @Override
    public EventPark getEventPark() {
        return eventPark;
    }

    @Override
    public void bindTo(Collection<OpenLogEventConfig> registry) {
        registry.add(OpenLogEventConfig.builder().mt(Common.Mt.oCpx_Reporting.original()).eventType(OcpxReportingEvent.class).build());
        registry.add(OpenLogEventConfig.builder().mt(Common.Mt.rtbConversion.original()).eventType(RtbConversionEvent.class).build());
        registry.add(OpenLogEventConfig.builder().mt(Common.Mt.OceanengineClickTracker.original()).eventType(OceanengineClickMonitorEvent.class).build());
        registry.add(OpenLogEventConfig.builder().mt(Common.Mt.DhhConversion.original()).eventType(DhhConversionEvent.class).build());
        registry.add(OpenLogEventConfig.builder().mt(Common.Mt.ClickTrackerForRtb.original()).eventType(RtbClickTrackerEvent.class).build());
        registry.add(OpenLogEventConfig.builder().mt(Common.Mt.oCpxClickTrackerForCommon.original()).eventType(MediaClickMonitorEvent.class).build());
        registry.add(OpenLogEventConfig.builder().mt(Common.Mt.oCpxFeedbackForCommon.original()).eventType(ConversionFeedbackEvent.class).build());
    }
}
