package com.bxm.adscounter.service.openlog.common.feedback;

import com.bxm.adscounter.model.RtbMedia;
import com.bxm.openlog.sdk.KeyValueMap;

/**
 * 回传给媒体
 *
 * @author tangx
 * @date 2022/7/20 16:27
 */
public interface ConversionFeedback {

    /**
     * 回传接口
     *
     * @param feedbackLog openlog参数
     * @param clickId       媒体的回传id
     * @param targetType    媒体的回传转化类型
     */
    void feedback(KeyValueMap feedbackLog, String clickId, String targetType);

    /**
     * 自定义更新处理
     *
     * @param clickLog 点击监测日志
     */
    default void update(KeyValueMap clickLog) {}

    /**
     * 根据点击日志创建一个扩展参数：ext，当收到回传时仍然可以获取这个值。
     *
     * @param clickLog 点击监测日志
     * @return 扩展参数内容。请保证返回的内容原值与 URL 编码后一致，否则可能
     * 会出现 {@link com.bxm.adscounter.service.openlog.common.report.Reporter} 回传不了给我们。
     */
    default String createExtParams(KeyValueMap clickLog) {
        return null;
    }

    /**
     * 指定的rtbMedia
     *
     * @return RtbMedia
     */
    RtbMedia rtbMedia();
}
