package com.bxm.adscounter.service.openlog.common.feedback.impl;

import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.domobOcpx.DomobOcpxRtbIntegration;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedback;
import com.bxm.openlog.sdk.KeyValueMap;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangx
 * @date 2022/7/20 16:28
 */
@Slf4j
@Configuration
public class DomobConversionFeedback implements ConversionFeedback{

    private final DomobOcpxRtbIntegration domobOcpxRtbIntegration;

    public DomobConversionFeedback(DomobOcpxRtbIntegration domobOcpxRtbIntegration) {
        this.domobOcpxRtbIntegration = domobOcpxRtbIntegration;
    }


    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        try {
            domobOcpxRtbIntegration.doFeedback(FeedbackRequest.builder()
                    .keyValueMap(feedbackLog)
                    .eventType(targetType)
                    .clickId(clickId)
                    .build(), 2);
        } catch (RtbIntegrationException ignored) {
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.DOMOB;
    }

}
