package com.bxm.adscounter.service.openlog.common.feedback.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.rtb.common.utils.HttpClientUtils;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedback;
import com.bxm.adscounter.service.openlog.common.report.Reporter;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.params.ProductionCommonParam;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.web.util.UriComponentsBuilder;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 广点通
 *
 * @author allen
 * @date 2022-08-11
 * @since 1.0
 */
@Slf4j
@Configuration
public class GuangdiantongConversionFeedback implements ConversionFeedback {

    public final static String DEVICE_OS_TYPE = "device_os_type";

    private final HttpClient httpClient;

    public GuangdiantongConversionFeedback() {
        this.httpClient = HttpClientUtils.createHttpClient(50, 100,
                1000, 500, 1000);
    }

    @Override
    public void update(KeyValueMap clickLog) {
        String os = clickLog.getFirst(DEVICE_OS_TYPE);
        if (StringUtils.isNotBlank(os)) {
            clickLog.put(Reporter.NAME_X_OS, os);
        }
    }

    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        String feedbackUrlBase64 = UrlHelper.urlDecode(clickId);

        // base64转码
        String feedbackUrl = new String(Base64.decodeBase64(feedbackUrlBase64));

        if (StringUtils.isBlank(feedbackUrl)) {
            return;
        }
        String url = UriComponentsBuilder.fromUriString(UrlHelper.urlDecode(feedbackUrl)).build().toString();

        JSONObject extParamsJsonObject = new JSONObject();
        String extParams = feedbackLog.getFirst(Reporter.NAME_EXT_PARAMS);
        if (StringUtils.isNotBlank(extParams)) {
            byte[] base64 = Base64.decodeBase64(extParams);
            extParamsJsonObject = JSONObject.parseObject(StringHelper.convert(base64));
            if (Objects.isNull(extParamsJsonObject)) {
                log.warn("[guangdiantong] extParams is null!");
            }
        }

        String oaid = extParamsJsonObject.getString(ProductionCommonParam.OAID);
        String imeiMd5 = extParamsJsonObject.getString(ProductionCommonParam.IMEI_MD5);
        String idfaMd5 = extParamsJsonObject.getString(ProductionCommonParam.IDFA_MD5);
        String androidIdMd5 = extParamsJsonObject.getString(ProductionCommonParam.ANDROIDID_MD5);
        String os = extParamsJsonObject.getString(DEVICE_OS_TYPE);
        boolean isIos = Objects.equals(os, "ios");

        UserId.UserIdBuilder userIdBuilder = UserId.builder();

        if (StringUtils.isNotBlank(imeiMd5)) {
            userIdBuilder.hash_imei(imeiMd5);
        } else if (StringUtils.isNotBlank(idfaMd5) && isIos) {
            userIdBuilder.hash_idfa(idfaMd5);
        }else if (StringUtils.isNotBlank(oaid)) {
            userIdBuilder.oaid(oaid);
        } else if (StringUtils.isNotBlank(androidIdMd5)) {
            userIdBuilder.hash_android_id(androidIdMd5);
        }

        List<Action> actions = Lists.newArrayList(Action.builder()
                .action_type(targetType)
                .user_id(userIdBuilder.build())
                .build()
        );
        GdtReqeuset gdtReqeuset = GdtReqeuset.builder().actions(actions).build();
        String entity = JsonHelper.convert(gdtReqeuset);
        HttpPost post = new HttpPost(url);
        post.setEntity(new StringEntity(entity, StandardCharsets.UTF_8));
        post.addHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_UTF8_VALUE);
        try {
            HttpResponse httpResponse = httpClient.execute(post);
            log.info("[guangdiantong] ocpx conversion success - url: {} - requestJson: {} - response: {} ",
                    url,
                    entity,
                    EntityUtils.toString(httpResponse.getEntity(), StandardCharsets.UTF_8));
        } catch (IOException e) {
            log.error("execute: ", e);
        } finally {
            post.releaseConnection();
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.GUANGDIANTONG;
    }


    @Data
    @AllArgsConstructor
    @Builder
    private static class GdtReqeuset {
        private List<Action> actions;
    }

    @Data
    @AllArgsConstructor
    @Builder
    private static class Action {
        private String action_type;
        private UserId user_id;
    }

    @Data
    @AllArgsConstructor
    @Builder
    private static class UserId {
        private String hash_imei;
        private String hash_idfa;
        private String hash_android_id;
        private String hash_mac;
        private String oaid;
    }


    /**
     * 根据点击日志创建一个扩展参数：ext，当收到回传时仍然可以获取这个值。
     *
     * @param clickLog 点击监测日志
     * @return 扩展参数内容
     */
    @Override
    public String createExtParams(KeyValueMap clickLog) {
        Map<String, String> ext = Maps.newHashMap();
        ext.put(ProductionCommonParam.OAID, clickLog.getFirst(ProductionCommonParam.OAID));
        ext.put(ProductionCommonParam.IMEI, clickLog.getFirst(ProductionCommonParam.IMEI));
        ext.put(ProductionCommonParam.IMEI_MD5, clickLog.getFirst(ProductionCommonParam.IMEI_MD5));
        ext.put(ProductionCommonParam.IDFA, clickLog.getFirst(ProductionCommonParam.IDFA));
        ext.put(ProductionCommonParam.IDFA_MD5, clickLog.getFirst(ProductionCommonParam.IDFA_MD5));
        ext.put(ProductionCommonParam.ANDROIDID, clickLog.getFirst(ProductionCommonParam.ANDROIDID));
        ext.put(ProductionCommonParam.ANDROIDID_MD5, clickLog.getFirst(ProductionCommonParam.ANDROIDID_MD5));
        ext.put(DEVICE_OS_TYPE, clickLog.getFirst(DEVICE_OS_TYPE));
        return Base64.encodeBase64URLSafeString(JsonHelper.convert2bytes(ext));
    }

    public static void main(String[] args) {
        GuangdiantongConversionFeedback guangdiantongConversionFeedback = new GuangdiantongConversionFeedback();
        KeyValueMap keyValueMap = new KeyValueMap();
        String clickId = "aHR0cCUzQSUyRiUyRnRyYWNraW5nLmUucXEuY29tJTJGY29udiUzRmNiJTNEQkVBYzE5LXFkZ05GUnlwa1JjN0ZhWGw5VW91MV9zeGlaYzY1RzFxdjdTSSUyNTNEJTI2Y29udl9pZCUzRDg0OTAzNjY%3D";
        String targetType = "ACTIVATE_APP";



        keyValueMap.put(ProductionCommonParam.IMEI_MD5, "f9efca36a3c30e1cf28170d86ecbf5e9");

        String extParams = guangdiantongConversionFeedback.createExtParams(keyValueMap);

        keyValueMap.set(Reporter.NAME_EXT_PARAMS, extParams);

        guangdiantongConversionFeedback.feedback(keyValueMap, clickId, targetType);
    }

}
