package com.bxm.adscounter.service.openlog.common.feedback.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.huawei.HuaweiRtbIntegration;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedback;
import com.bxm.adscounter.service.openlog.common.report.Reporter;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * 华为
 *
 * @author tangxiao
 * @date 2022-12-02
 * @since 1.0
 */
@Slf4j
@Configuration
public class HuaweiConversionFeedback implements ConversionFeedback {


    private static final String CONTENT_ID = "content_id";
    private static final String CAMPAIGN_ID = "campaign_id";
    private static final String OAID = "oaid";


    private final HuaweiRtbIntegration huaweiRtbIntegration;

    public HuaweiConversionFeedback(HuaweiRtbIntegration huaweiRtbIntegration) {
        this.huaweiRtbIntegration = huaweiRtbIntegration;
    }


    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {

        String extParams = feedbackLog.getFirst(Reporter.NAME_EXT_PARAMS);
        if (StringUtils.isBlank(extParams)) {
            log.warn("Huawei Cannot found extParams");
            return;
        }
        byte[] base64 = Base64.decodeBase64(extParams);
        JSONObject extParamsJsonObject = JSONObject.parseObject(StringHelper.convert(base64));
        String contentId = extParamsJsonObject.getString(CONTENT_ID);
        String campaignId = extParamsJsonObject.getString(CAMPAIGN_ID);
        String oaid = extParamsJsonObject.getString(OAID);

        feedbackLog.put(CONTENT_ID, contentId);
        feedbackLog.put(CAMPAIGN_ID, campaignId);
        feedbackLog.put(OAID, oaid);

        FeedbackRequest request = FeedbackRequest.builder()
                .keyValueMap(feedbackLog)
                .clickId(clickId)
                .eventType(targetType)
                .build();

        try {
            huaweiRtbIntegration.doFeedback(request);
        } catch (RtbIntegrationException e) {
            log.error(e.getMessage(), e);
        }

    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.HUAWEI;
    }

    @Override
    public String createExtParams(KeyValueMap clickLog) {
        Map<String, String> ext = Maps.newHashMap();
        ext.put(CONTENT_ID, clickLog.getFirst(CONTENT_ID));
        ext.put(CAMPAIGN_ID, clickLog.getFirst(CAMPAIGN_ID));
        ext.put(OAID, clickLog.getFirst(OAID));
        return Base64.encodeBase64URLSafeString(JsonHelper.convert2bytes(ext));
    }
}
