package com.bxm.adscounter.service.openlog.common.feedback.impl;

import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.rtb.common.utils.HttpClientUtils;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedback;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

import java.io.IOException;

/**
 * 爱奇艺
 * @author allen
 * @date 2022-09-07
 * @since 1.0
 */
@Slf4j
@Configuration
public class IqiyiConversionFeedback implements ConversionFeedback {

    private final HttpClient httpClient;

    public IqiyiConversionFeedback() {
        this.httpClient = HttpClientUtils.createHttpClient(50, 100,
                1000, 500, 1000);
    }

    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        String feedbackUrl = UrlHelper.urlDecode(clickId);
        if (StringUtils.isBlank(feedbackUrl)) {
            return;
        }
        String url = UriComponentsBuilder.fromUriString(feedbackUrl).replaceQueryParam("event_type", targetType).build().toString();
        HttpGet get = new HttpGet(url);
        try {
            httpClient.execute(get);
            log.info("[iqiyi] ocpx conversion success - url: {} ", url);
        } catch (IOException e) {
            log.error("execute: ", e);
        } finally {
            get.releaseConnection();
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.IQIYI;
    }
}
