package com.bxm.adscounter.service.openlog.common.feedback.impl;

import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouRtbIntegration;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedback;
import com.bxm.openlog.sdk.KeyValueMap;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangx
 * @date 2022/7/20 16:28
 */
@Slf4j
@Configuration
public class KuaishouConversionFeedback implements ConversionFeedback{

    private final KuaishouRtbIntegration kuaishouRtbIntegration;

    public KuaishouConversionFeedback(KuaishouRtbIntegration kuaishouRtbIntegration) {
        this.kuaishouRtbIntegration = kuaishouRtbIntegration;
    }

    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        try {
            kuaishouRtbIntegration.doFeedback(FeedbackRequest.builder()
                    .keyValueMap(feedbackLog)
                    .eventType(targetType)
                    .clickId(clickId)
                    .build(), 2);
        } catch (RtbIntegrationException ignored) {
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.KUAISHOU;
    }
}
