package com.bxm.adscounter.service.openlog.common.feedback.impl;

import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.juliang.OceanEngineRtbIntegration;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedback;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.params.ProductionCommonParam;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * @author allen
 * @date 2022-09-20
 * @since 1.0
 */
@Configuration
@Slf4j
public class OceanengineConversionFeedback implements ConversionFeedback {

    private final OceanEngineRtbIntegration rtbIntegration;

    public OceanengineConversionFeedback(OceanEngineRtbIntegration rtbIntegration) {
        this.rtbIntegration = rtbIntegration;
    }

    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        try {

            rtbIntegration.doFeedback(FeedbackRequest.builder()
                    .keyValueMap(feedbackLog)
                    .eventType(targetType)
                    .clickId(clickId)
                    .ocpxRequest(true)
                    .build(), 2);
        } catch (RtbIntegrationException ignored) {
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.OCEANENGINE;
    }


    @Override
    public String createExtParams(KeyValueMap clickLog) {
        return clickLog.getFirst("source");
    }
}
