package com.bxm.adscounter.service.openlog.common.feedback.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.rtb.common.utils.HttpClientUtils;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedback;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

/**
 * 趣头条回传实现
 * @author jingyu.li
 * @date 2022-11-09
 */
@Slf4j
@Configuration
public class QuTouTiaoConversionFeedback implements ConversionFeedback {

    private final HttpClient httpClient;

    public QuTouTiaoConversionFeedback() {
        this.httpClient = HttpClientUtils.createHttpClient(50, 100,
                1000, 500, 1000);
    }


    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        if (StringUtils.isEmpty(clickId)) {
            return;
        }

        String feedbackUrl = UrlHelper.urlDecode(clickId);
        String url = UriComponentsBuilder.fromUriString(feedbackUrl)
                .replaceQueryParam("op2", targetType)
                .replaceQueryParam("opt_active_time", System.currentTimeMillis()).build().toString();

        HttpGet get = new HttpGet(url);
        try {
            HttpResponse response = httpClient.execute(get);
            String entity = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            log.info("qutoutiao feedback success url:{} response:{}",url,JSONObject.parseObject(entity));
        } catch (IOException e) {
            log.warn("qutoutiao feedback error url:{} feedbackLog:{} clickId:{} targetType:{} exception:{}",url,feedbackLog,clickId,targetType,e.getMessage());
        } finally {
            get.releaseConnection();
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.QUTOUTIAO;
    }
}
