package com.bxm.adscounter.service.openlog.common.feedback.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.vivo.VivoRtbIntegration;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedback;
import com.bxm.adscounter.service.openlog.common.report.Reporter;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * @author allen
 * @date 2022-08-19
 * @since 1.0
 */
@Slf4j
@Configuration
public class VivoConversionFeedback implements ConversionFeedback {

    private final VivoRtbIntegration vivoRtbIntegration;

    public VivoConversionFeedback(VivoRtbIntegration vivoRtbIntegration) {
        this.vivoRtbIntegration = vivoRtbIntegration;
    }

    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        try {
            JSONObject json = new JSONObject();
            String extParams = feedbackLog.getFirst(Reporter.NAME_EXT_PARAMS);
            if (StringUtils.isNotBlank(extParams)) {
                try {
                    byte[] base64 = Base64.decodeBase64(extParams);
                    json = JSONObject.parseObject(StringHelper.convert(base64));
                } catch (Exception e) {
                    log.warn("{} - {}", extParams, e.getMessage());
                }
            }
            String srcid = json.getString("srcid");
            if (StringUtils.isBlank(srcid)) {
                srcid = "ds-202208191223";
            }
            String pkgname = json.getString("pkgname");
            if (StringUtils.isBlank(pkgname)) {
                pkgname = "com.sankuai.meituan";
            }
            String advertiserid = json.getString("advertiserid");
            String creativeid = json.getString("creativeid");

            PositionRtb config = new PositionRtb();
            // accessToken
            config.setToken("29a5682c520e1d344cf530cdf6dd4f896a0742c3fc5e55b92d313eaf26167ea9");
            // vivoSrcId
            config.setSourceId(srcid);
            // vivoAdvertiserId
            config.setCustomerId(advertiserid);

            feedbackLog.putIfNotBlank("advertiserid", advertiserid);
            feedbackLog.putIfNotBlank("creativeid", creativeid);
            feedbackLog.putIfNotBlank("pkgname", pkgname);

            FeedbackRequest request = FeedbackRequest.builder()
                    .config(config)
                    .keyValueMap(feedbackLog)
                    .clickId(clickId)
                    .eventType(targetType)
                    .referrer(json.getString("pageUrl"))
                    .build();
            vivoRtbIntegration.doFeedback(request, 2);
        } catch (RtbIntegrationException ignored) {
        }
    }

    @Override
    public String createExtParams(KeyValueMap clickLog) {
        Map<String, String> ext = Maps.newHashMap();
        ext.put("advertiserid", clickLog.getFirst("advertiserid"));
        ext.put("creativeid", clickLog.getFirst("creativeid"));
        ext.put("pkgname", clickLog.getFirst("pkgname"));
        ext.put("srcid", clickLog.getFirst("srcid"));
        ext.put("pageUrl", clickLog.getFirst("pageUrl"));
        return Base64.encodeBase64URLSafeString(JsonHelper.convert2bytes(ext));
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.VIVO;
    }
}
