package com.bxm.adscounter.service.openlog.common.feedback.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.xiaomiocpx.XiaomiOcpxRtbIntegration;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedback;
import com.bxm.adscounter.service.openlog.common.report.Reporter;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.params.ProductionCommonParam;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * 小米
 *
 * @author tangxiao
 * @date 2022-09-15
 * @since 1.0
 */
@Slf4j
@Configuration
public class XiaomiConversionFeedback implements ConversionFeedback {

    private final XiaomiOcpxRtbIntegration xiaomiOcpxRtbIntegration;

    public XiaomiConversionFeedback(XiaomiOcpxRtbIntegration xiaomiOcpxRtbIntegration) {
        this.xiaomiOcpxRtbIntegration = xiaomiOcpxRtbIntegration;
    }


    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {

        // 为防止ext_params 获取不到设备号的情况
        String oaid = feedbackLog.getFirst("x_oaid");
        String imei = feedbackLog.getFirst("x_imei");

        if (StringUtils.isBlank(oaid) && StringUtils.isBlank(imei)) {
            log.info("[xiaomiOcpx] Cannot found 'x_oaid' or 'x_imei'");

            String extParams = feedbackLog.getFirst(Reporter.NAME_EXT_PARAMS);
            if (StringUtils.isBlank(extParams)) {
                log.info("[xiaomiOcpx] Cannot found 'extParams'");
                return;
            }
            byte[] base64 = Base64.decodeBase64(extParams);
            JSONObject extParamsJsonObject = JSONObject.parseObject(StringHelper.convert(base64));
            oaid = extParamsJsonObject.getString(ProductionCommonParam.OAID);
            imei = extParamsJsonObject.getString(ProductionCommonParam.IMEI);
        }

        if (StringUtils.isBlank(oaid) && StringUtils.isBlank(imei)) {
            log.info("[xiaomiOcpx] Cannot find 'oaid' or 'imei' from extParams");
            return;
        }

        feedbackLog.put("oaid", oaid);
        feedbackLog.put("imei", imei);

        FeedbackRequest request = FeedbackRequest.builder()
                .keyValueMap(feedbackLog)
                .clickId(clickId)
                .eventType(targetType)
                .build();

        try {
            xiaomiOcpxRtbIntegration.doFeedback(request);
        } catch (RtbIntegrationException ignore) {
        }

    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.XIAOMI;
    }

    @Override
    public String createExtParams(KeyValueMap clickLog) {
        Map<String, String> ext = Maps.newHashMap();
        ext.put(ProductionCommonParam.OAID, clickLog.getFirst(ProductionCommonParam.OAID));
        ext.put(ProductionCommonParam.IMEI, clickLog.getFirst(ProductionCommonParam.IMEI));
        ext.put("test", "1");
        return Base64.encodeBase64URLSafeString(JsonHelper.convert2bytes(ext));
    }
}
