package com.bxm.adscounter.service.openlog.common.listener;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.impl.baidu.BaiduRtbIntegration;
import com.bxm.adscounter.service.openlog.common.event.RtbClickTrackerEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2022-07-20
 * @since 1.0
 * @see com.bxm.adscounter.service.openlog.inads.listener.index.BaiduIndexShowEventListener
 */
@Configuration
public class BaiduClickTrackerEventListener implements EventListener<RtbClickTrackerEvent> {

    private final BaiduRtbIntegration baiduRtbIntegration;

    public BaiduClickTrackerEventListener(BaiduRtbIntegration baiduRtbIntegration) {
        this.baiduRtbIntegration = baiduRtbIntegration;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(RtbClickTrackerEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        if (Rtb.Baidu.getType() == NumberUtils.toInt(keyValueMap.getFirst(Common.Param.RTB_ID))) {
            baiduRtbIntegration.saveClickTracker(keyValueMap);
        }
    }
}
