package com.bxm.adscounter.service.openlog.common.listener;

import com.bxm.adscounter.service.openlog.common.event.ConversionFeedbackEvent;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedbackDispatcher;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * 通用的广告主转化回传
 * https://bxmrds.yuque.com/mizhsy/qc669f/rgie7h
 * @author tangxiao
 * @date 2022-07-20
 * @since 1.0
 * @see MediaClickEventListener
 */
@Slf4j
@Configuration
public class ConversionFeedbackEventListener implements EventListener<ConversionFeedbackEvent> {

    private final ConversionFeedbackDispatcher conversionFeedbackDispatcher;

    public ConversionFeedbackEventListener(ConversionFeedbackDispatcher conversionFeedbackDispatcher) {
        this.conversionFeedbackDispatcher = conversionFeedbackDispatcher;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ConversionFeedbackEvent event) {
        conversionFeedbackDispatcher.dispatch(event);
    }

}
