package com.bxm.adscounter.service.openlog.common.listener;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.juliang.OceanEngineRtbIntegration;
import com.bxm.adscounter.service.openlog.common.event.DhhConversionEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * 淘宝大航海转化回传。
 *
 * https://bxmrds.yuque.com/mizhsy/qc669f/myvw0u
 *
 * @author allen
 * @date 2022-04-28
 * @since 1.0
 * @see OceanengineClickEventListener
 */
@Slf4j
@Configuration
public class DhhConversionEventListener implements EventListener<DhhConversionEvent> {

    private final OceanEngineRtbIntegration oceanEngineRtbIntegration;

    public DhhConversionEventListener(OceanEngineRtbIntegration oceanEngineRtbIntegration) {
        this.oceanEngineRtbIntegration = oceanEngineRtbIntegration;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(DhhConversionEvent event) {
        KeyValueMap m = event.getLog();

        String clickId = m.getFirst("click_id");
        String convDef = m.getFirst("conv_def");

        String transformType = m.getFirst("transformType");

        if (StringUtils.isBlank(convDef)) {
            log.warn("{} Not value of 'conv_def'", clickId);
            return;
        }

        Map<String, String> conv = new HashMap<>();
        String[] strings = StringUtils.split(convDef, ",");
        for (String string : strings) {
            String[] arr = StringUtils.split(string, "-");
            if (arr.length < 2) {
                continue;
            }
            String src = arr[0];
            String dest = arr[1];
            conv.put(src, dest);
        }

        if (!conv.containsKey(transformType)) {
            return;
        }
        String targetType = conv.get(transformType);

        try {
            oceanEngineRtbIntegration.doFeedback(FeedbackRequest.builder()
                    .keyValueMap(m)
                    .eventType(targetType)
                    .clickId(clickId)
                    .build());
        } catch (RtbIntegrationException ignored) {
        }
    }
}
