package com.bxm.adscounter.service.openlog.common.listener;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.iqiyi.IqiyiRtbIntegration;
import com.bxm.adscounter.service.openlog.common.event.RtbClickTrackerEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2022-08-17
 * @since 1.0
 */
@Configuration
public class IqiyiClickTrackerEventListener implements EventListener<RtbClickTrackerEvent> {

    private final IqiyiRtbIntegration iqiyiRtbIntegration;
    private final RatioControlRtbIntegration ratioControlRtbIntegration;

    public IqiyiClickTrackerEventListener(IqiyiRtbIntegration iqiyiRtbIntegration, RatioControlRtbIntegration ratioControlRtbIntegration) {
        this.iqiyiRtbIntegration = iqiyiRtbIntegration;
        this.ratioControlRtbIntegration = ratioControlRtbIntegration;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(RtbClickTrackerEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        if (Rtb.iQiyi.getType() == NumberUtils.toInt(keyValueMap.getFirst(Common.Param.RTB_ID))) {
            iqiyiRtbIntegration.saveClickTracker(keyValueMap);
            String adGroupId = keyValueMap.getFirst(Common.Param.AD_GROUP_ID);
            ratioControlRtbIntegration.onClick(iqiyiRtbIntegration, keyValueMap, adGroupId);
        }
    }
}
