package com.bxm.adscounter.service.openlog.common.listener;

import com.bxm.adscounter.service.openlog.common.event.MediaClickMonitorEvent;
import com.bxm.adscounter.service.openlog.common.report.ReporterDispatcher;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.springframework.context.annotation.Configuration;

/**
 * 媒体点击监测上报给指定广告主 oCPX
 * https://bxmrds.yuque.com/mizhsy/qc669f/rgie7h
 * @author tangxiao
 * @date 2022-07-20
 * @since 1.0
 */
@Configuration
public class MediaClickEventListener implements EventListener<MediaClickMonitorEvent> {

    private final ReporterDispatcher reporterDispatcher;

    public MediaClickEventListener(ReporterDispatcher reporterDispatcher) {
        this.reporterDispatcher = reporterDispatcher;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(MediaClickMonitorEvent event) {
        reporterDispatcher.dispatch(event);
    }

}
