package com.bxm.adscounter.service.openlog.common.listener;

import com.bxm.adscounter.service.openlog.common.event.OcpxReportingEvent;
import com.bxm.adscounter.service.reporting.ReportingLogger;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2022-02-16
 * @since 1.0
 */
@Slf4j
@Configuration
public class OcpxReportingLogStorageEventListener implements EventListener<OcpxReportingEvent> {

    private final ReportingLogger reportingLogger;

    public OcpxReportingLogStorageEventListener(ReportingLogger reportingLogger) {
        this.reportingLogger = reportingLogger;
    }

    @Override
    @Subscribe
    public void consume(OcpxReportingEvent event) {
        KeyValueMap map = event.getLog();
        String reqUri = map.getFirst("req_uri");
        String resBody = map.getFirst("res_body");
        reportingLogger.collect(reqUri, 200, resBody, null);
    }
}
