package com.bxm.adscounter.service.openlog.common.listener;

import com.bxm.adscounter.service.openlog.common.event.RtbConversionEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.logging.extension.CustomLoggingWriter;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * @author allen
 * @date 2022-02-18
 * @since 1.0
 */
@Slf4j
@Configuration
public class RtbConversionStorageEventListener implements EventListener<RtbConversionEvent> {

    private final CustomLoggingWriter writer;

    public RtbConversionStorageEventListener(@Qualifier("customLoggingWriterForRtbFeedback") CustomLoggingWriter writer) {
        this.writer = writer;
    }

    @Override
    @Subscribe
    public void consume(RtbConversionEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        Map<String, String> data = Maps.newHashMap();
        keyValueMap.forEach((key, value) -> {
            String split = ",";
            StringBuilder s = new StringBuilder();
            if (CollectionUtils.isNotEmpty(value)) {
                value.forEach(e -> {
                    s.append(e).append(split);
                });
            }
            data.put(key, StringUtils.removeEnd(s.toString(), split));
        });

        writer.write(data);
    }
}
