package com.bxm.adscounter.service.openlog.common.listener;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.vivo.VivoRtbIntegration;
import com.bxm.adscounter.service.openlog.common.event.RtbClickTrackerEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2022-07-27
 * @since 1.0
 */
@Configuration
public class VivoClickTrackerEventListener implements EventListener<RtbClickTrackerEvent> {

    private final VivoRtbIntegration vivoRtbIntegration;
    private final RatioControlRtbIntegration ratioControlRtbIntegration;

    public VivoClickTrackerEventListener(VivoRtbIntegration vivoRtbIntegration, RatioControlRtbIntegration ratioControlRtbIntegration) {
        this.vivoRtbIntegration = vivoRtbIntegration;
        this.ratioControlRtbIntegration = ratioControlRtbIntegration;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(RtbClickTrackerEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        if (Rtb.Vivo.getType() == NumberUtils.toInt(keyValueMap.getFirst(Common.Param.RTB_ID))) {
            vivoRtbIntegration.saveClickTracker(keyValueMap);
            String adGroupId = keyValueMap.getFirst(Common.Param.AD_GROUP_ID);
            ratioControlRtbIntegration.onClick(vivoRtbIntegration, keyValueMap, adGroupId);
        }
    }
}
