package com.bxm.adscounter.service.openlog.common.report;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.openlog.sdk.KeyValueMap;

import java.util.Objects;

/**
 * 广告主上报者接口
 * @author tangx
 * @date 2022/7/20 15:38
 */
public interface Reporter {

    String NAME_EXT_PARAMS = "ext_params";

    /**
     * 系统类型参数名称，值：android、ios
     */
    String NAME_X_OS = "x_os";

    /**
     * 发送广告主点击上报
     *
     * @param clickLog 媒体点击 KeyValueMap
     * @param bxmFeedbackUrl 变现猫接收广告主回传的URL，没有经过URLEncode。
     */
    void report(KeyValueMap clickLog, String bxmFeedbackUrl);

    RtbAdvertiser rtbAdvertiser();


    default String getDefault(Object object) {
        return Objects.toString(object, "");
    }
}
