package com.bxm.adscounter.service.openlog.common.report.impl;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.service.openlog.common.report.Reporter;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Common;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author allen
 * @date 2022-10-24
 * @since 1.0
 */
@Slf4j
@Configuration
public class BxmmReporter implements Reporter {

    private final OpenLogClient openLogClient;

    public BxmmReporter(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) {
        if (!isHitRatio(clickLog)) {
            return;
        }
        String url = UriComponentsBuilder.fromUriString(bxmFeedbackUrl)
                .queryParam(RtbAdvertiser.BianXianMaoM.getTransferType(), "1")
                .build()
                .toString();
        openLogClient.asyncRequest(url);
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.BianXianMaoM;
    }

    private boolean isHitRatio(KeyValueMap m) {
        String convRatio = m.getFirst(Common.Param.CONV_RATIO);
        if (StringUtils.isNotBlank(convRatio)) {
            double ratio = Double.parseDouble(convRatio);
            if (ratio >= 100) {
                return true;
            }
            double random = RandomUtils.nextDouble(0, 100);
            return random < ratio;
        }
        return false;
    }
}
