package com.bxm.adscounter.service.openlog.common.report.impl;

import com.bxm.adscounter.integration.taobao.TaobaoIntegration;
import com.bxm.adscounter.integration.taobao.TaobaoProperties;
import com.bxm.adscounter.integration.taobao.TaobaoRequest;
import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.service.openlog.common.report.Reporter;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.params.ProductionCommonParam;
import com.bxm.warcar.utils.TypeHelper;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangx
 * @date 2022/7/21 16:24
 */
@Configuration
public class DhhReporter implements Reporter {

    private final TaobaoIntegration taobaoIntegration;
    private final TaobaoProperties taobaoProperties;

    public DhhReporter(TaobaoIntegration taobaoIntegration, TaobaoProperties taobaoProperties) {
        this.taobaoIntegration = taobaoIntegration;
        this.taobaoProperties = taobaoProperties;
    }

    @Override
    public void report(KeyValueMap clickLog, String feedbackUrl) {
        String imei = clickLog.getFirst(ProductionCommonParam.IMEI);
        String oaid = clickLog.getFirst(ProductionCommonParam.OAID);
        String oaidMd5 = clickLog.getFirst(ProductionCommonParam.OAID_MD5);
        String idfa = clickLog.getFirst(ProductionCommonParam.IDFA);
        String app = clickLog.getFirst("app");
        String taskId = clickLog.getFirst("taskId");
        String channel = clickLog.getFirst("channel");
        String advertisingSpaceId = clickLog.getFirst("advertisingSpaceId");
        String adid = clickLog.getFirst("adid");
        String cid = clickLog.getFirst("cid");
        String adAgent = clickLog.getFirst("adAgent");

        TaobaoRequest request = new TaobaoRequest();
        request.setReportUrl(taobaoProperties.getReportClickUrl())
                .setTaskId(taskId)
                .setApp(app)
                .setChannel(channel)
                .setAdid(adid)
                .setCid(cid)
                .setAdAgent(adAgent)
                .setAdvertisingSpaceId(advertisingSpaceId)
                .setImei(imei)
                .setOaid(oaid)
                .setOaidMd5(oaidMd5)
                .setIdfa(idfa)
                .setCallbackUrl(UrlHelper.urlEncode(feedbackUrl))
                .setTimestamp(TypeHelper.castToString(System.currentTimeMillis()));

        taobaoIntegration.report(request);
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.TAOBAO;
    }

}
