package com.bxm.adscounter.service.openlog.common.report.impl;

import com.bxm.adscounter.integration.didi.DidiIntegration;
import com.bxm.adscounter.integration.didi.DidiRequest;
import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.service.openlog.common.report.Reporter;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.params.ProductionCommonParam;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.utils.UrlHelper;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @author tangx
 * @date 2022/7/20 15:39
 */
@Configuration
public class DidiReporter implements Reporter {

    private final DidiIntegration didiIntegration;

    public DidiReporter(DidiIntegration didiIntegration) {
        this.didiIntegration = didiIntegration;
    }

    @Override
    public void report(KeyValueMap clickLog, String feedbackUrl) {
        DidiRequest request = new DidiRequest();
        Map<String, String> parameters = new HashMap<>();
        String idfa = clickLog.getFirst(ProductionCommonParam.IDFA);
        String idfaMd5 = clickLog.getFirst(ProductionCommonParam.IDFA_MD5);

        String deviceOs = StringUtils.isBlank(idfa) && StringUtils.isBlank(idfaMd5) ? "android" : "IOS";

        parameters.put("adx", clickLog.getFirst("adx"));
        parameters.put("device_os", deviceOs);
        parameters.put("ip", clickLog.getFirst("ip"));
        parameters.put("client_time", TypeHelper.castToString(System.currentTimeMillis()));
        parameters.put("ua", clickLog.getFirst("ua"));
        parameters.put("callback_url", UrlHelper.urlEncode(feedbackUrl));
        parameters.put("account_id", clickLog.getFirst("account_id"));
        parameters.put("product_id", clickLog.getFirst("product_id"));

        parameters.put("imei", clickLog.getFirst(ProductionCommonParam.IMEI));
        parameters.put("imei_md5", clickLog.getFirst(ProductionCommonParam.IMEI_MD5));
        parameters.put("idfa", idfa);
        parameters.put("idfa_md5", idfaMd5);
        parameters.put("oaid", clickLog.getFirst(ProductionCommonParam.OAID));
        parameters.put("oaid_md5", clickLog.getFirst(ProductionCommonParam.OAID_MD5));
        parameters.put("android_id_md5", clickLog.getFirst(ProductionCommonParam.ANDROIDID_MD5));
        parameters.put("level_two_media", clickLog.getFirst("level_two_media"));
        parameters.put("ad_target", clickLog.getFirst("ad_target"));
        parameters.put("lp_type", clickLog.getFirst("lp_type"));
        parameters.put("ad_team", clickLog.getFirst("ad_team"));
        parameters.put("dchn", clickLog.getFirst("dchn"));

        request.setParameters(parameters);

        didiIntegration.report(request);
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.DIDI;
    }

}
