package com.bxm.adscounter.service.openlog.common.report.impl;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.service.openlog.common.report.Reporter;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

import java.io.IOException;
import java.util.Objects;

/**
 * 高德
 * @author tangxiao
 * @date 2022-09-16
 * @since 1.0
 */
@Slf4j
@Configuration
public class GaodeReporter implements Reporter {

    private static final String URL = "http://amap-ocpx-online.amap.com/ws/channel/common-device-infos";
    private final HttpClient httpClient;
    private static final String ANDROID_SOURCE = "bianxianmao_wy_bxm_tt_01";
    private static final String IOS_SOURCE = "bianxianmao_wy_bxm_tt_02";


    public GaodeReporter() {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(2000).setConnectTimeout(1000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) {
        boolean isIos = false;
        if (StringUtils.isNotBlank(clickLog.getFirst(Inads.Param.IDFA)) || StringUtils.isNotBlank(clickLog.getFirst(Inads.Param.IDFA_MD5))) {
            isIos = true;
        }

        String requestId = RandomStringUtils.randomAlphanumeric(8);
        String reqUrl = UriComponentsBuilder.fromUriString(URL)
                .replaceQueryParam("source", isIos ? IOS_SOURCE : ANDROID_SOURCE)
                .replaceQueryParam("imei", getDefault(clickLog.getFirst(Inads.Param.IMEI)))
                .replaceQueryParam("oaid", getDefault(clickLog.getFirst(Inads.Param.OAID)))
                .replaceQueryParam("oaid_md5", getDefault(clickLog.getFirst(Inads.Param.OAID_MD5)))
                .replaceQueryParam("idfa", getDefault(clickLog.getFirst(Inads.Param.IDFA)))
                .replaceQueryParam("idfa_md5", getDefault(clickLog.getFirst(Inads.Param.IDFA_MD5)))
                .replaceQueryParam("callback", getDefault(UrlHelper.urlEncode(bxmFeedbackUrl)))
                .replaceQueryParam("bxmId", requestId)
                .toUriString();

        HttpGet get = new HttpGet(reqUrl);
        try {
            if (log.isInfoEnabled()) {
                log.info("{} - gaode reporting: {}", requestId, reqUrl);
            }
            HttpResponse res = httpClient.execute(get);
            String body = EntityUtils.toString(res.getEntity());
            if (log.isInfoEnabled()) {
                log.info("{} - gaode response: {}", requestId, body);
            }
        } catch (IOException e) {
            log.error("{} - gaode report occur exception: {}", requestId, e.getMessage());
        } finally {
            get.releaseConnection();
        }
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.GaoDe;
    }

}
