package com.bxm.adscounter.service.openlog.common.report.impl;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.service.openlog.common.report.Reporter;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.utils.UUIDHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.context.annotation.Configuration;

import java.io.IOException;
import java.util.Objects;

/**
 * 同程
 * @author allen
 * @date 2022-09-07
 * @since 1.0
 */
@Slf4j
@Configuration
public class TongChengReporter implements Reporter {

    private static final String URL = "http://adhub.ly.com/collect/trace/i?tcCallback=http%3A%2F%2Fpay.hemayouxi.cn%2Fhome%2FPay798%2Fnotice%3Fimei_md5%3D__IMEI_MD5__%26oaid%3D__OAID__%26os%3D__OS__%26callback%3Dhttp%253A%252F%252Fadhub.ly.com%252Fcollect%252Ftrace%252Fi%253Finfo%253DkDds3qZcDonP03oAhx5XClgWjC6gJuO3m5X7IvviKobJuCxuoP6E45X52yNgUbEW3dul9UguEfsUutT96qFfLdcV8EjTVyZH6AjQ7F%25252Fub6QjrC6WxKgdaZuPcKq%25252FljZnJTXR37UWwMIqyMededRPTK%25252FcCnADtQkup6kYOMgmSrUGSfb%25252FfC6AtXpY6TdYJ0bto1%25252Bnq%25252F4Y2p8xN2aPgJ6BjNUkZRs1x%25252Br38%25252Btr0xbO6dRFZ1Te%25252B%25252FGoftpZxoQBFXeUr4lAPNE7R8SbfMftw%25252FAw5Aa7E5PbqTNfT06%25252BiPFlVUfnI%25252FSSa3Tg3baki91mw8o%25252BFMHv1uNhHTzLZG7p8og9AlcqX5JulHv1cMwULUZFFWkWPjoADuZO5FRakAgHt7w%25252F%2526uuid%253D__UUID__%2526action_time%253D__ACTION_TIME__%2526action%253D__ACTION__%2526bxm_request_id%253D__REQUEST_ID__&uuid=__UUID__&tcAction=2&adInfo=__ENCRYPT__&bxm_callback=__CALLBACK__&device_id=__DEVICE_ID__&time=__TIME__&medium_logic_id=__MEDIUM_LOGIC_ID__&gaid_md5=__GAID_MD5__&gaid=__GAID__&idfa_md5=__IDFA_MD5__&idfa=__IDFA__&oaid_md5=__OAID_MD5__&oaid=__OAID__&androidid_md5=__ANDROID_ID_MD5__&androidid=__ANDROID_ID__&imei_md5=__IMEI_MD5__&imei=__IMEI__&os=__OS__&ua=__UA__&ip=__IP__&plan_id=__PLAN_ID__&request_id=__REQUEST_ID__";
    private final HttpClient httpClient;

    public TongChengReporter() {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(2000).setConnectTimeout(1000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) {
        String requestId = UUIDHelper.generate();
        String reqUrl = URL.replaceAll("__REQUEST_ID__", requestId)
                .replaceAll("__PLAN_ID__", getDefault(clickLog.getFirst(Inads.Param.ADID)))
                .replaceAll("__IMEI__", getDefault(clickLog.getFirst(Inads.Param.IMEI)))
                .replaceAll("__IDFA__", getDefault(clickLog.getFirst(Inads.Param.IDFA)))
                .replaceAll("__OAID__", getDefault(clickLog.getFirst(Inads.Param.OAID)))
                .replaceAll("__OAID_MD5__", getDefault(clickLog.getFirst(Inads.Param.OAID_MD5)))
                .replaceAll("__OS__", getDefault(clickLog.getFirst(Inads.Param.OS)))
                .replaceAll("__IP__", getDefault(clickLog.getFirst(Inads.Param.IP)))
                .replaceAll("__UA__", getDefault(UrlHelper.urlEncode(clickLog.getFirst(Inads.Param.UA))))
                .replaceAll("__CALLBACK__", getDefault(UrlHelper.urlEncode(bxmFeedbackUrl)))
                .replaceAll("__TIME__", getDefault(System.currentTimeMillis()))
                .replaceAll("__ANDROID_ID__", getDefault(clickLog.getFirst(Inads.Param.ANDROIDID)))
                .replaceAll("__MEDIUM_LOGIC_ID__", requestId)
                .replaceAll("__IMEI_MD5__", getDefault(clickLog.getFirst(Inads.Param.IMEI_MD5)))
                .replaceAll("__IDFA_MD5__", getDefault(clickLog.getFirst(Inads.Param.IDFA_MD5)))
                .replaceAll("__ANDROID_ID_MD5__", getDefault(clickLog.getFirst(Inads.Param.ANDROIDID_MD5)))
                .replaceAll("__GAID__", getDefault(clickLog.getFirst(Inads.Param.GAID)))
                .replaceAll("__GAID_MD5__", getDefault(clickLog.getFirst(Inads.Param.GAID_MD5)));
        HttpGet get = new HttpGet(reqUrl);
        try {
            if (log.isInfoEnabled()) {
                log.info("{} - tongcheng reporting: {}", requestId, reqUrl);
            }
            HttpResponse res = httpClient.execute(get);
            String body = EntityUtils.toString(res.getEntity());
            if (log.isInfoEnabled()) {
                log.info("{} - tongcheng response: {}", requestId, body);
            }
        } catch (IOException e) {
            log.error("{} - tongcheng report occur exception: {}", requestId, e.getMessage());
        } finally {
            get.releaseConnection();
        }
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.TongCheng;
    }

}
