package com.bxm.adscounter.service.openlog.inads;

import com.bxm.adscounter.service.openlog.inads.event.*;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEventBusBean;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEventConfig;
import com.bxm.warcar.integration.eventbus.EventPark;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;

/**
 * @author allen
 * @date 2022-03-01
 * @since 1.0
 */
@Configuration
public class DefaultInadsOpenLogEventBusBean implements OpenLogEventBusBean {

    private final EventPark eventPark;

    public DefaultInadsOpenLogEventBusBean(EventPark eventPark) {
        this.eventPark = eventPark;
    }

    @Override
    public String getId() {
        return "ADSCOUNTER";
    }

    @Override
    public Production getProduction() {
        return Production.INADS;
    }

    @Override
    public EventPark getEventPark() {
        return eventPark;
    }

    @Override
    public void bindTo(Collection<OpenLogEventConfig> registry) {
        registry.add(OpenLogEventConfig.builder().mt(Inads.Mt.IndexShow.original()).eventType(IndexShowEvent.class).build());
        registry.add(OpenLogEventConfig.builder().mt(Inads.Mt.ActivityPageShow.original()).eventType(ActivityPageShowEvent.class).build());
        registry.add(OpenLogEventConfig.builder().mt(Inads.Mt.ActivityAttend.original()).eventType(ActivityAttendEvent.class).condition(log -> NumberUtils.toInt(log.getFirst(Inads.Param.BAN)) == 0).build());
        registry.add(OpenLogEventConfig.builder().mt(Inads.Mt.AdRequest.original()).eventType(AdRequestEvent.class).condition(log -> NumberUtils.toInt(log.getFirst(Inads.Param.BAN)) == 0).build());
        registry.add(OpenLogEventConfig.builder().mt(Inads.Mt.AdShow.original()).eventType(AdShowEvent.class).condition(log -> NumberUtils.toInt(log.getFirst(Inads.Param.BAN)) == 0).build());
        registry.add(OpenLogEventConfig.builder().mt(Inads.Mt.AdClick.original()).eventType(AdClickEvent.class).condition(log -> NumberUtils.toInt(log.getFirst(Inads.Param.BAN)) == 0).build());
        registry.add(OpenLogEventConfig.builder().mt(Inads.Mt.AdConversion.original()).eventType(AdConversionEvent.class).condition(log -> NumberUtils.toInt(log.getFirst(Inads.Param.BAN)) == 0).build());
        registry.add(OpenLogEventConfig.builder().mt(Inads.Mt.DownloadFinish.original()).eventType(DownloadFinishEvent.class).build());
        registry.add(OpenLogEventConfig.builder().mt(Inads.Mt.InstallFinish.original()).eventType(InstallFinishEvent.class).build());
        registry.add(OpenLogEventConfig.builder().mt(Inads.Mt.DpSuccess.original()).eventType(DpSuccessEvent.class).build());
        registry.add(OpenLogEventConfig.builder().mt(Inads.Mt.AdLandpageClickImage.original()).eventType(AdLandpageClickImageEvent.class).build());
    }
}
