package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.model.DotTypeEnum;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.model.constant.RedisKeyGenerator;
import com.bxm.adscounter.service.events.ActivityJoinEvent;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.adscounter.service.utils.GeneralEndpointUtils;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

/**
 * 活动参与事件监听器
 *
 * @author allen
 * @date 2022-03-02
 * @since 1.0
 */
@Configuration
public class ActivityAttendEventListener implements EventListener<ActivityAttendEvent> {

    private final AsyncEventPark asyncEventPark;

    private Counter counter;

    public ActivityAttendEventListener(AsyncEventPark asyncEventPark,@Qualifier("jedisCounter") Counter counter) {
        this.asyncEventPark = asyncEventPark;
        this.counter = counter;
    }

    @Override
    @Subscribe
    public void consume(ActivityAttendEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        GeneralEndpoint endpoint = GeneralEndpointUtils.fromInads(DotTypeEnum.INTERACTIVE_ADS, keyValueMap);
        //统计本用户当天的参与次数
        //counter.incrementAndGet(PositionRTBUtils.stringActivityAttend(endpoint.getUid()), (int) DateHelper.getRemainSecondsOfToday());
        asyncEventPark.post(new ActivityJoinEvent(this, endpoint));
    }
}
