package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.model.DotTypeEnum;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.service.events.ActivityShowEvent;
import com.bxm.adscounter.service.openlog.inads.event.ActivityPageShowEvent;
import com.bxm.adscounter.service.utils.GeneralEndpointUtils;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * 活动页面曝光事件监听器
 *
 * @author allen
 * @date 2022-03-01
 * @since 1.0
 */
@Slf4j
@Configuration
public class ActivityPageShowEventListener implements EventListener<ActivityPageShowEvent> {

    private final AsyncEventPark asyncEventPark;

    public ActivityPageShowEventListener(AsyncEventPark asyncEventPark) {
        this.asyncEventPark = asyncEventPark;
    }

    @Override
    @Subscribe
    public void consume(ActivityPageShowEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        GeneralEndpoint endpoint = GeneralEndpointUtils.fromInads(DotTypeEnum.INTERACTIVE_ADS, keyValueMap);
        asyncEventPark.post(new ActivityShowEvent(this, endpoint));
    }
}
