package com.bxm.adscounter.service.openlog.inads.listener;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.DotTypeEnum;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.rtb.common.utils.InadsExtValueUtils;
import com.bxm.adscounter.service.events.TicketClickAsyncEvent;
import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.adscounter.service.utils.GeneralEndpointUtils;
import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.SyncEventPark;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.TypeHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Date;
import java.util.Map;
import java.util.Objects;

/**
 * 广告点击事件监听器
 *
 * @author allen
 * @date 2022-03-18
 * @since 1.0
 */
@Slf4j
@Configuration
public class AdClickEventListener implements EventListener<AdClickEvent> {

    private final Fetcher fetcher;
    private final AsyncEventPark asyncEventPark;

    public AdClickEventListener(Fetcher fetcher, AsyncEventPark asyncEventPark,
                                SyncEventPark syncEventPark) {
        this.fetcher = fetcher;
        this.asyncEventPark = asyncEventPark;
    }

    @Override
    @Subscribe
    public void consume(AdClickEvent event) {
        KeyValueMap map = event.getLog();
        String adid = map.getFirst(Inads.Param.ADID);
        String bxmId = map.getFirst(Inads.Param.BXMID);
        Ticket ticket = get(adid);
        if (Objects.isNull(ticket)) {
            log.warn("Not found: {}", adid);
            return;
        }

        ClickRequest req = new ClickRequest();
        req.setUid(map.getFirst(Inads.Param.UID));
        req.setTicketId(TypeHelper.castToBigInteger(adid));
        req.setPosition(map.getFirst(Inads.Param.TAGID));
        req.setValid(false);
        req.setBillid(bxmId);
        req.setAssetsId(TypeHelper.castToBigInteger(map.getFirst(Inads.Param.CREATEID)));
        req.setEntrTicketId(TypeHelper.castToBigInteger(map.getFirst(Inads.Param.EN_ADID)));
        req.setEntrAssetsId(TypeHelper.castToBigInteger(map.getFirst(Inads.Param.EN_CID)));
        req.setBidid(map.getFirst(Inads.Param.BIDID));
        req.setObidid(map.getFirst(Inads.Param.OBIDID));
        req.setAdxAppId(map.getFirst(Inads.Param.ADX_APPID));
        req.setAdverCost(map.getFirst(Inads.Param.ADVER_OFFER_PRICE));
        req.setCost(!StringUtils.equalsIgnoreCase(map.getFirst(Inads.Param.PAYED), "1"));

        ticket.setTime(new Date());
        ticket.setOfferPrice(NumberUtils.toInt(map.getFirst(Inads.Param.OFFER_PRICE)));
        ticket.setBillid(bxmId);

        //发券次序
        ticket.setUserBxmCount(TypeHelper.castToLong(map.getFirst(Inads.Param.SEQ)));
        //加速出券发券类型  0 加速发券 1或者空 不是加速出券
        ticket.setExploreType(getExploreType(map));

        asyncEventPark.post(new TicketClickEvent(this, req, ticket));

        // 发送事件，给本工程监听器
        GeneralEndpoint endpoint = GeneralEndpointUtils.fromInads(DotTypeEnum.INTERACTIVE_ADS, map);
        asyncEventPark.post(new TicketClickAsyncEvent(this, endpoint, ticket));
    }
    public Integer getExploreType(KeyValueMap keyValueMap) {
        String ext = keyValueMap.getFirst(Inads.Param.EXT);
        if (StringUtils.isBlank(ext)) {
            return null;
        }
        Object value = null;
        try {
            Map<String, Object>  map = InadsExtValueUtils.parse(ext);
            value = map.get("exb");
        } catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("parseObject: '{}' on log: {}", e.getMessage(), keyValueMap);
            }
        }
        return TypeHelper.castToInt(value);
    }

    public static void main(String[] args) {
        String ext = "exb:1";

    }

    private Ticket get(String adid) {
        return fetcher.hfetch(TicketKeyGenerator.getAllTickets(), adid, Ticket.class);
    }
}
