package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.model.DotTypeEnum;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.service.events.TicketAcquireEvent;
import com.bxm.adscounter.service.openlog.inads.event.AdRequestEvent;
import com.bxm.adscounter.service.utils.GeneralEndpointUtils;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.springframework.context.annotation.Configuration;

/**
 * 广告请求事件监听器
 *
 * @author allen
 * @date 2022-03-15
 * @since 1.0
 */
@Configuration
public class AdRequestEventListener implements EventListener<AdRequestEvent> {

    private final AsyncEventPark asyncEventPark;

    public AdRequestEventListener(AsyncEventPark asyncEventPark) {
        this.asyncEventPark = asyncEventPark;
    }

    @Override
    @Subscribe
    public void consume(AdRequestEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        GeneralEndpoint endpoint = GeneralEndpointUtils.fromInads(DotTypeEnum.INTERACTIVE_ADS, keyValueMap);
        asyncEventPark.post(new TicketAcquireEvent(this, endpoint));
    }
}
