package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.model.DotTypeEnum;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.service.events.TicketShowEvent;
import com.bxm.adscounter.service.openlog.inads.event.AdShowEvent;
import com.bxm.adscounter.service.utils.GeneralEndpointUtils;
import com.bxm.adsprod.counter.event.TicketViewEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

import java.util.Date;
import java.util.Objects;

/**
 * 广告曝光事件监听器
 *
 * @author allen
 * @date 2022-03-15
 * @since 1.0
 */
@Slf4j
@Configuration
public class AdShowEventBindingBxmIdListener implements EventListener<AdShowEvent> {

    private final Updater updater;

    public AdShowEventBindingBxmIdListener(@Qualifier("jedisUpdaterForTFB") Updater updater) {
        this.updater = updater;
    }

    @Override
    @Subscribe
    public void consume(AdShowEvent event) {
        KeyValueMap map = event.getLog();
        String sbid = map.getFirst(Inads.Param.SBID);
        String bxmId = map.getFirst(Inads.Param.BXMID);
        if (StringUtils.isEmpty(sbid) || StringUtils.isEmpty(bxmId)) {
            return;
        }
        updater.update(sbidBindingBxmid(sbid), bxmId, 15 * 24 * 60 * 60);
    }

    public static KeyGenerator sbidBindingBxmid(String sbid) {
        return () -> KeyBuilder.build(sbid);
    }

}
