package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.model.DotTypeEnum;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.service.events.TicketShowEvent;
import com.bxm.adscounter.service.openlog.inads.event.AdShowEvent;
import com.bxm.adscounter.service.utils.GeneralEndpointUtils;
import com.bxm.adsprod.counter.event.TicketViewEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.TypeHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.util.Date;
import java.util.Objects;

/**
 * 广告曝光事件监听器
 *
 * @author allen
 * @date 2022-03-15
 * @since 1.0
 */
@Slf4j
@Configuration
public class AdShowEventListener implements EventListener<AdShowEvent> {

    private final Fetcher fetcher;
    private final AsyncEventPark asyncEventPark;

    public AdShowEventListener(Fetcher fetcher, AsyncEventPark asyncEventPark) {
        this.fetcher = fetcher;
        this.asyncEventPark = asyncEventPark;
    }

    @Override
    @Subscribe
    public void consume(AdShowEvent event) {
        KeyValueMap map = event.getLog();
        // get Ticket Object
        String adid = map.getFirst(Inads.Param.ADID);
        Ticket ticket = get(adid);
        if (Objects.isNull(ticket)) {
            log.warn("Not found: {}", adid);
            return;
        }
        ticket.setTime(new Date());

        // 发送消息队列，给 adsprod-counter 订阅。
        ViewRequest req = new ViewRequest();
        req.setUid(map.getFirst(Inads.Param.UID));
        req.setTicketId(TypeHelper.castToBigInteger(adid));
        req.setPosition(map.getFirst(Inads.Param.TAGID));
        req.setAssetsId(TypeHelper.castToBigInteger(map.getFirst(Inads.Param.CREATEID)));
        req.setEntrTicketId(TypeHelper.castToBigInteger(map.getFirst(Inads.Param.EN_ADID)));
        req.setEntrAssetsId(TypeHelper.castToBigInteger(map.getFirst(Inads.Param.EN_CID)));
        req.setBidid(map.getFirst(Inads.Param.BIDID));
        req.setObidid(map.getFirst(Inads.Param.OBIDID));
        req.setAdxAppId(map.getFirst(Inads.Param.ADX_APPID));

        asyncEventPark.post(new TicketViewEvent(this, req, ticket));

        // 发送事件，给本工程监听器
        GeneralEndpoint endpoint = GeneralEndpointUtils.fromInads(DotTypeEnum.INTERACTIVE_ADS, map);
        asyncEventPark.post(new TicketShowEvent(this, endpoint, ticket));
    }

    private Ticket get(String adid) {
        return fetcher.hfetch(TicketKeyGenerator.getAllTickets(), adid, Ticket.class);
    }
}
