package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.openlog.inads.event.DownloadFinishEvent;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.util.Objects;

/**
 * 下载完成事件监听器
 *
 * @author allen
 * @date 2022-03-22
 * @since 1.0
 */
@Slf4j
@Configuration
public class DownloadFinishEventListener implements EventListener<DownloadFinishEvent> {

    private final Properties properties;
    private final OpenLogClient openLogClient;

    public DownloadFinishEventListener(Properties properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    public void consume(DownloadFinishEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        this.sendWinLog(keyValueMap);
    }

    private void sendWinLog(KeyValueMap keyValueMap) {
        KeyValueMap customizedParams = new KeyValueMap();
        customizedParams.add(Inads.Param.MT, Inads.Mt.AdConversion.original());
        customizedParams.add(Inads.Param.CONVERSION_STATUS, "1");
        customizedParams.add(Inads.Param.CONVERSION_TYPE, "0");
        String uri = keyValueMap.createOpenLogRequestUri(properties.getOpenLogRequestDomain(), customizedParams, true);
        openLogClient.asyncRequest(uri, fallback -> {
            log.warn("request: {}, exception: {}", fallback.getUrl(),
                    Objects.nonNull(fallback.getException()) ? fallback.getException().getMessage() : "-");
        });
    }
}
