package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.model.DotTypeEnum;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.service.events.ActivityAcquireEvent;
import com.bxm.adscounter.service.openlog.inads.event.IndexShowEvent;
import com.bxm.adscounter.service.utils.GeneralEndpointUtils;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.springframework.context.annotation.Configuration;

/**
 * 中间页曝光事件监听器
 * @author allen
 * @date 2022-03-01
 * @since 1.0
 */
@Configuration
public class IndexShowEventListener implements EventListener<IndexShowEvent> {

    private final AsyncEventPark asyncEventPark;

    public IndexShowEventListener(AsyncEventPark asyncEventPark) {
        this.asyncEventPark = asyncEventPark;
    }

    @Override
    @Subscribe
    public void consume(IndexShowEvent event) {
        KeyValueMap map = event.getLog();
        GeneralEndpoint endpoint = GeneralEndpointUtils.fromInads(DotTypeEnum.INTERACTIVE_ADS, map);
        asyncEventPark.post(new ActivityAcquireEvent(this, endpoint));
    }
}
